import type { Metadata } from "next";
import localFont from "next/font/local";
import "./globals.css";

const vazir = localFont({
  src: [
    {
      path: "../../public/fonts/vazir-FD/Vazir-Thin-FD.woff2",
      weight: "300",
      style: "normal",
    },
    {
      path: "../../public/fonts/vazir-FD/Vazir-Regular-FD.woff2",
      weight: "400",
      style: "normal",
    },
    {
      path: "../../public/fonts/vazir-FD/Vazir-Medium-FD.woff2",
      weight: "500",
      style: "normal",
    },
  ],
  variable: "--font-vazir",
  display: "swap",
});

export const metadata: Metadata = {
  title: "کمبِر | استعلام و تأمین قطعات یدکی خودرو",
  description:
    "کمبِر پلتفرم هوشمند استعلام قیمت و سفارش‌گذاری قطعات یدکی خودرو برای مغازه‌دارهاست؛ واسطی بین فروشگاه و تأمین‌کننده با پیشنهادهای مقایسه‌ای و تحویل سریع.",
  icons: {
    icon: "/favicon.ico",
  },
  metadataBase: new URL("https://camber.example.com"),
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="fa" dir="rtl">
      <body
        className={`${vazir.variable} antialiased min-h-screen bg-background text-foreground font-sans`}
      >
        {children}
      </body>
    </html>
  );
}
