const faqs = [
  {
    question: "کمبِر برای چه نوع کسب‌وکارهایی مناسب است؟",
    answer:
      "تمرکز کمبِر روی مغازه‌های لوازم یدکی، عمده‌فروشی‌ها و فروشگاه‌هایی است که روزانه با چندین تأمین‌کننده مختلف برای تأمین قطعات خودرو در ارتباط هستند.",
  },
  {
    question: "آیا استفاده از کمبِر برای مغازه‌دار هزینه دارد؟",
    answer:
      "مدل مالی کمبِر بر اساس همکاری دوطرفه با تأمین‌کنندگان و مغازه‌دارها طراحی شده است. در نسخه فعلی، راه‌اندازی و استفاده برای مغازه‌دارها بدون هزینه اولیه است و شرایط نهایی همکاری در تماس تلفنی هماهنگ می‌شود.",
  },
  {
    question: "چطور می‌توانم تأمین‌کنندگان مورد اعتماد خودم را به کمبِر اضافه کنم؟",
    answer:
      "بعد از ثبت‌نام و راه‌اندازی اولیه، می‌توانید لیست تأمین‌کنندگان فعلی خود را در اختیار تیم کمبِر قرار دهید تا پس از طی فرآیند احراز، به شبکه تأمین‌کنندگان شما در سامانه اضافه شوند.",
  },
  {
    question: "آیا کمبِر خودش قطعه می‌فروشد؟",
    answer:
      "خیر. کمبِر یک پلتفرم واسط است و خودش انبار قطعه ندارد؛ فقط فرایند استعلام، مقایسه و سفارش‌گذاری بین مغازه‌دار و تأمین‌کننده را هوشمند و شفاف می‌کند.",
  },
];

export function FaqSection() {
  return (
    <section
      id="faq"
      className="border-b border-border bg-background py-14 sm:py-16"
    >
      <div className="mx-auto max-w-4xl px-4 sm:px-6 lg:px-8">
        <div className="mb-6 space-y-2 text-center">
          <h2 className="text-xl font-semibold text-foreground sm:text-2xl">
            پرسش‌های پرتکرار درباره کمبِر
          </h2>
          <p className="text-sm text-muted-foreground">
            اگر سؤال دیگری دارید، در نسخه محصول می‌توانیم این بخش را به پشتیبانی
            آنلاین یا فرم تماس متصل کنیم.
          </p>
        </div>

        <div className="space-y-3">
          {faqs.map((item) => (
            <details
              key={item.question}
              className="group rounded-2xl border border-border bg-white p-4"
            >
              <summary className="flex cursor-pointer list-none items-center justify-between gap-4">
                <h3 className="text-sm font-medium text-foreground">
                  {item.question}
                </h3>
                <span className="inline-flex h-6 w-6 items-center justify-center rounded-full border border-border text-xs text-muted-foreground transition group-open:rotate-45 group-open:border-black group-open:text-black">
                  +
                </span>
              </summary>
              <p className="mt-3 text-xs leading-relaxed text-muted-foreground">
                {item.answer}
              </p>
            </details>
          ))}
        </div>
      </div>
    </section>
  );
}

