import Link from "next/link";
import { ThemeToggle } from "@/components/theme-toggle";

export function SiteHeader() {
  return (
    <header className="sticky top-0 z-40 border-b border-border bg-background/95 backdrop-blur-sm">
      <div className="mx-auto flex h-16 max-w-6xl items-center justify-between px-4 sm:px-6 lg:px-8">
        <Link
          href="#"
          className="flex items-center gap-2 text-sm font-semibold tracking-tight"
        >
          <span className="inline-flex h-8 w-8 items-center justify-center rounded-xl bg-black text-xs font-bold text-white shadow-sm shadow-black/20">
            C
          </span>
          <span className="flex flex-col leading-tight">
            <span className="text-base">کمبِر</span>
            <span className="text-[11px] text-muted-foreground">
              استعلام قطعات یدکی
            </span>
          </span>
        </Link>

        <nav className="hidden items-center gap-6 text-sm text-muted-foreground sm:flex">
          <a href="#how-it-works" className="transition hover:text-foreground">
            چگونه کار می‌کند
          </a>
          <a href="#features" className="transition hover:text-foreground">
            مزایا
          </a>
          <a href="#faq" className="transition hover:text-foreground">
            پرسش‌ها
          </a>
        </nav>

        <div className="flex items-center gap-3">
          <a
            href="#cta"
            className="hidden rounded-full border border-border px-3 py-1.5 text-xs font-medium text-muted-foreground transition hover:border-foreground/70 hover:text-foreground sm:inline-flex"
          >
            ورود تأمین‌کننده
          </a>
          <a
            href="#cta"
            className="inline-flex items-center justify-center rounded-full bg-black px-4 py-1.5 text-xs font-semibold text-white shadow-sm shadow-black/25 transition hover:bg-neutral-800"
          >
            درخواست دسترسی مغازه‌دار
          </a>
          <ThemeToggle />
        </div>
      </div>
    </header>
  );
}

